﻿IF OBJECT_ID(N'[dbo].[SiteCollectionRepositorySite]', 'U') IS NOT NULL
    DROP TABLE [dbo].[SiteCollectionRepositorySite];
GO
IF OBJECT_ID(N'[dbo].[SiteCollectionRepository]', 'U') IS NOT NULL
    DROP TABLE [dbo].[SiteCollectionRepository];
GO
IF OBJECT_ID(N'[dbo].[SiteCollectionRepositoryConfig]', 'U') IS NOT NULL
    DROP TABLE [dbo].[SiteCollectionRepositoryConfig];
GO

-- Creating table 'SiteCollectionRepositoryConfig'
CREATE TABLE [dbo].[SiteCollectionRepositoryConfig] (
    [Id] nvarchar(50)  NOT NULL,
    [Prefix] nvarchar(max)  NOT NULL,
    [MaxSitesPerCollection] int  NOT NULL,
    [AllowMaxSitesCollectionOverflow] bit  NOT NULL,
    [MaxSizeInMB] int  NOT NULL,
    [Owner] nvarchar(max)  NOT NULL,
    [Template] nvarchar(max)  NOT NULL,
    [EmptySlotsThreshold] int  NOT NULL
);
GO

-- Creating table 'SiteCollectionRepository'
CREATE TABLE [dbo].[SiteCollectionRepository] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Url] nvarchar(max)  NOT NULL,
    [Status] int  NOT NULL,
    [RepositoryConfig_Id] nvarchar(50)  NOT NULL
);
GO

-- Creating table 'SiteCollectionRepositorySite'
CREATE TABLE [dbo].[SiteCollectionRepositorySite] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Url] nvarchar(max)  NOT NULL,
    [LastChecked] datetime  NOT NULL,
    [Repository_Id] int  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'SiteCollectionRepositoryConfig'
ALTER TABLE [dbo].[SiteCollectionRepositoryConfig]
ADD CONSTRAINT [PK_SiteCollectionRepositoryConfig]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'SiteCollectionRepository'
ALTER TABLE [dbo].[SiteCollectionRepository]
ADD CONSTRAINT [PK_SiteCollectionRepository]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'SiteCollectionRepositorySite'
ALTER TABLE [dbo].[SiteCollectionRepositorySite]
ADD CONSTRAINT [PK_SiteCollectionRepositorySite]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating foreign key on [RepositoryConfig_Id] in table 'SiteCollectionRepository'
ALTER TABLE [dbo].[SiteCollectionRepository]
ADD CONSTRAINT [FK_RepositoryConfigRepository]
    FOREIGN KEY ([RepositoryConfig_Id])
    REFERENCES [dbo].[SiteCollectionRepositoryConfig]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_RepositoryConfigRepository'
CREATE INDEX [IX_FK_RepositoryConfigRepository]
ON [dbo].[SiteCollectionRepository]
    ([RepositoryConfig_Id]);
GO

-- Creating foreign key on [Repository_Id] in table 'SiteCollectionRepositorySite'
ALTER TABLE [dbo].[SiteCollectionRepositorySite]
ADD CONSTRAINT [FK_RepositoryRepositorySite]
    FOREIGN KEY ([Repository_Id])
    REFERENCES [dbo].[SiteCollectionRepository]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_RepositoryRepositorySite'
CREATE INDEX [IX_FK_RepositoryRepositorySite]
ON [dbo].[SiteCollectionRepositorySite]
    ([Repository_Id]);
GO